#include <iostream>
#include <vector>
#include <algorithm>
using namespace std;

// 0) pravimo strukturu parametri koja ce vaziti u celom programu i funkcijama i procedurama cemo je uve prenositi PO REFERENCI
struct parametri {
    int indeks_najmanjeg_broja;
    int indeks_najveceg_broja;
    int indeks_broja_koji_izbacujemo;  // MORA BITI UMANJEN ZA 1 Jer JE U ULAZNIM PARAMTERIMA REDNI BROJ A NE INDEKS U A
                                       // UMANJENJE RADIMO CIM PROCITAM TAJ REDNI BROJ I NA DALJE JE TO INDEKS
    int broj_koji_izbacujemo;
    int broj_koji_ubacujemo;
    int duzina_niza_a;
    int duzina_niza_v2;
    int broj_poteza;
};

//1) pravimo strukturu "Broj"
struct Broj {  
    int broj;
    int count;
    int zbir;
    int prev;   //index prethodnog u nizu - pokazivac na prvi sledeci sa manjim zbirom ili -1 ako je bas taj elemenat sa najmanjim
    int next;   //index sledeceg u nizu - pokazivac na prvi sledeci sa vecim zbirom ili -9 ako je bas taj elemenat sa najvecim zbirom
};

struct Upit {
    int t;  //tip upita
    int x; 
    int y;
};

int upit_1 (const vector<Broj>& v2, const parametri& p) {
    
    Broj t = v2[p.indeks_najmanjeg_broja];
    int zbir = 0;

    for(int i = 1; i <= p.broj_poteza; i++) {
        zbir += t.zbir;
        if(i < p.broj_poteza) {
            t = v2[t.next];     //idemo dalje samo ako nismo na kraju
        }
    }

    return zbir;
}

void azuriraj_listu_izbacen_element(vector<Broj>& v2, vector<int>& pozicija, parametri& p) {

    //nadjemo poziciju izbacenog broja u vektoru pozicija
    int t_index = pozicija[p.broj_koji_izbacujemo];   // O(1)

    v2[t_index].zbir -= p.broj_koji_izbacujemo;
    v2[t_index].count--;

    int t_zbir = v2[t_index].zbir;

    //AKO BROJ VISE NE POSTOJI U NIZU
    if(t_zbir == 0) {
        if(p.indeks_najmanjeg_broja == t_index) {
            // broj koji izbacujemo je broj sa najmanjim zbirom
            p.indeks_najmanjeg_broja = v2[t_index].next;
            v2[p.indeks_najmanjeg_broja].prev = -1;
        }
        else if(p.indeks_najveceg_broja == t_index) {
            //broj koji izbacujemo je broj sa najvecim zbirom
            p.indeks_najveceg_broja = v2[t_index].prev;
            v2[p.indeks_najveceg_broja].next = -9;
        }
        else{
            //zbir broja koji izbacujemo nema ni najmanji ni najveci zbir
            //spajamo dva susedna
            v2[v2[t_index].prev].next = v2[t_index].next;
            v2[v2[t_index].next].prev = v2[t_index].prev;
            
        }

        //izbacujemo ga iz v2 posto vise ne postoji u a
        v2[t_index].prev = v2[t_index].next = -99;
        pozicija[p.broj_koji_izbacujemo] = -1;
        p.duzina_niza_v2--;

        return;
    }

    if(t_index == p.indeks_najmanjeg_broja) {
        return;
    }

    int t_pos = v2[t_index].prev;

    while(t_pos != p.indeks_najmanjeg_broja and v2[t_pos].zbir > t_zbir) {
        t_pos = v2[t_pos].prev;
    }

    if(t_pos == v2[t_index].prev) {
        //ostaje na istom mestu
        return;
    }

    //1 od poslednjeg na 2. mesto
    if(t_index == p.indeks_najveceg_broja and t_pos == p.indeks_najmanjeg_broja and v2[p.indeks_najmanjeg_broja].zbir < t_zbir) {
        //stari sused
        v2[v2[t_index].prev].next = -9;

        p.indeks_najveceg_broja = v2[t_index].prev;

        //promenjeni broj
        v2[t_index].prev = p.indeks_najmanjeg_broja;
        v2[t_index].next = v2[p.indeks_najmanjeg_broja].next;

        //novi susedi
        v2[p.indeks_najmanjeg_broja].next = t_index;
        v2[v2[t_index].next].prev = t_index;

    }

    //2 od poslednjeg na 1. mesto
    else if(t_index == p.indeks_najveceg_broja and t_pos == p.indeks_najmanjeg_broja and v2[p.indeks_najmanjeg_broja].zbir >= t_zbir) {
        //stari sused
        v2[v2[t_index].prev].next = -9;

        p.indeks_najveceg_broja = v2[t_index].prev;

        //promenjeni broj
        v2[t_index].prev = -1;
        v2[t_index].next = p.indeks_najmanjeg_broja;

        p.indeks_najmanjeg_broja = t_index;

        //novi sused
        v2[v2[t_index].next].prev = t_index;
    }

    //3 od poslednjeg u sredinu
    else if(t_index == p.indeks_najveceg_broja and t_pos != p.indeks_najmanjeg_broja) {
        //stari sused
        v2[v2[t_index].prev].next = -9;

        p.indeks_najveceg_broja = v2[t_index].prev;

        //promenjeni broj
        v2[t_index].prev = t_pos;
        v2[t_index].next = v2[t_pos].next;

        //novi susedi
        v2[t_pos].next = t_index;
        v2[v2[t_index].next].prev = t_index;
    }

    //4 iz sredine u sredinu
    else if(t_index != p.indeks_najveceg_broja and t_pos != p.indeks_najmanjeg_broja) {
        //stari susedi
        v2[v2[t_index].prev].next = v2[t_index].next;
        v2[v2[t_index].next].prev = v2[t_index].prev;

        //promenjeni broj
        v2[t_index].prev = t_pos;
        v2[t_index].next = v2[t_pos].next;

        //novi susedi
        v2[t_pos].next = t_index;
        v2[v2[t_index].next].prev = t_index;
    }

    //5 iz sredine na 2. mesto
    else if(t_index != p.indeks_najveceg_broja and t_pos == p.indeks_najmanjeg_broja and v2[p.indeks_najmanjeg_broja].zbir < t_zbir) {
        //stari susedi
        v2[v2[t_index].prev].next = v2[t_index].next;
        v2[v2[t_index].next].prev = v2[t_index].prev;

        //promenjeni broj
        v2[t_index].prev = t_pos;
        v2[t_index].next = v2[t_pos].next;

        //novi susedi
        v2[t_pos].next = t_index;
        v2[v2[t_index].next].prev = t_index;
    }

    //6 iz sredine na 1. mesto
    else if(t_index != p.indeks_najveceg_broja and t_pos == p.indeks_najmanjeg_broja and v2[p.indeks_najmanjeg_broja].zbir >= t_zbir) {
        //stari susedi
        v2[v2[t_index].prev].next = v2[t_index].next;
        v2[v2[t_index].next].prev = v2[t_index].prev;
        
        //promenjeni broj
        v2[t_index].prev = -1;
        v2[t_index].next = p.indeks_najmanjeg_broja;

        p.indeks_najmanjeg_broja = t_index;

        //novi sused
        v2[v2[t_index].next].prev = t_index;
    }

    else {
        cout << "GRESKA U FUNKCIJI IZBACEN ELEMENT" << '\n';
    }

    return;
} 

void azuriraj_listu_dodat_element_koji_vec_postoji(vector<Broj>& v2, const vector<int>& pozicija, parametri& p) {

    //nadjemo poziciju dodatog broja u vektoru
    int t_index = pozicija[p.broj_koji_ubacujemo];   // O(1)

    v2[t_index].zbir += p.broj_koji_ubacujemo;
    v2[t_index].count++;

    int t_zbir = v2[t_index].zbir;
    int t_pos = v2[t_index].next;

    while(t_pos != p.indeks_najveceg_broja and v2[t_pos].zbir < t_zbir) {
        t_pos = v2[t_pos].next;
    }

    //ako se pozicije ne menjaju
    if(t_pos == v2[t_index].next) {
        return;
    }

    //AKO JE NA KRAJU
    if(t_pos == p.indeks_najveceg_broja) {

        if(t_zbir > v2[p.indeks_najveceg_broja].zbir) {
            //menjamo samo Ai i An
            v2[p.indeks_najveceg_broja].next = t_index;
            v2[t_index].prev = p.indeks_najveceg_broja;
            v2[t_index].next = -9;

            p.indeks_najveceg_broja = t_index;
        }
        else {
            v2[t_index].prev = v2[p.indeks_najveceg_broja].prev;
            v2[t_index].next = p.indeks_najveceg_broja;

            v2[v2[p.indeks_najveceg_broja].prev].next = t_index;
            v2[p.indeks_najveceg_broja].prev = t_index;
        }


        return;
    }

    //menjamo stare susede
    v2[v2[t_index].prev].next = v2[t_index].next;
    v2[v2[t_index].next].prev = v2[t_index].prev;

    //menjamo broj koji dodajemo
    v2[t_index].prev = v2[t_pos].prev;
    v2[t_index].next = t_pos;

    //menjamo nove susede
    v2[t_pos].prev = t_index;   
    v2[v2[t_index].prev].next = t_index;
    
    return;
} 

void azuriraj_listu_novi_dodati_element(vector<Broj>& v2, vector<int>& pozicija, parametri& p) {

    //1) pravimo strukturu "Broj"

    Broj t_broj;
    t_broj.broj = p.broj_koji_ubacujemo;
    t_broj.count = 1;
    t_broj.zbir = p.broj_koji_ubacujemo;
    t_broj.prev = -99;
    t_broj.next = -99;

    //dodajemo novi element u vektor
    v2.push_back(t_broj);
    p.duzina_niza_v2++;

    int t_index = p.duzina_niza_v2 - 1;

    //dodamo poziciju novog broja u vektoru
    pozicija[p.broj_koji_ubacujemo] = t_index;

    int t_pos = p.indeks_najmanjeg_broja;

    while(t_pos != p.indeks_najveceg_broja and v2[t_pos].zbir < p.broj_koji_ubacujemo) {
        t_pos = v2[t_pos].next;
    }

    //AKO JE NA POCETKU
    if(t_pos == p.indeks_najmanjeg_broja) {
        //menjamo samo Ai i A1
        v2[p.indeks_najmanjeg_broja].prev = t_index;
        v2[t_index].prev = -1;
        v2[t_index].next = p.indeks_najmanjeg_broja;

        p.indeks_najmanjeg_broja = t_index;

        return;
    }

    //AKO JE NA KRAJU
    if(t_pos == p.indeks_najveceg_broja) {

        if(p.broj_koji_ubacujemo > v2[p.indeks_najveceg_broja].zbir) {
            //menjamo samo Ai i An
            v2[p.indeks_najveceg_broja].next = t_index;
            v2[t_index].prev = p.indeks_najveceg_broja;
            v2[t_index].next = -9;

            p.indeks_najveceg_broja = t_index;
        }
        else {
            v2[t_index].prev = v2[p.indeks_najveceg_broja].prev;
            v2[t_index].next = p.indeks_najveceg_broja;

            v2[v2[p.indeks_najveceg_broja].prev].next = t_index;
            v2[p.indeks_najveceg_broja].prev = t_index;
        }


        return;
    }

    //menjamo dodat broj
    v2[t_index].prev = v2[t_pos].prev;
    v2[t_index].next = t_pos;

    //menjamo nove susede
    v2[t_pos].prev = t_index;   
    v2[v2[t_index].prev].next = t_index;

    return;
}

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(nullptr);

    //parametri 
    parametri p;
    
    //UNOS PODATAKA
    
    int N;  //broj karata u spilu
    int Q;  //broj upita
    cin >> N >> Q;
    
    vector<Broj> v(N + 1, {0, 0, 0, 0, 0});
    int a[N];   //spil karata
    
    //2) unosimo niz a i vektor v
    int A;
    for(int i = 0; i < N; i++) {
        cin >> A;
        a[i] = A;
        v[A].count++;
        v[A].zbir += A;
        v[A].broj = A;
    }

    Upit upiti[Q];
    
    for(int i = 0; i < Q; i++) {
        cin >> upiti[i].t >> upiti[i].x;
        if(upiti[i].t == 2) {
            cin >> upiti[i].y;
        }
        else{
            upiti[i].y = -1;
        }
    }

    // inicijalizacija vrednosti parametara
    p.duzina_niza_a = N;
    p.broj_koji_izbacujemo = -999;
    p.broj_koji_ubacujemo = -999;
    p.indeks_broja_koji_izbacujemo = -999;
    p.broj_poteza = -999;

    //4) pravimo vektor v2 bez nultih vrednosti
    vector<Broj> v2;
    v2.reserve(p.duzina_niza_a + 1);

    for(int i = 1; i <= p.duzina_niza_a; i++) {
        if(v[i].count > 0) {            // znaci da se taj broj pojavio bar jednom
            v2.push_back(v[i]);
        }
    }

    //5) sortiramo v2 po zbiru rastuce
    sort(v2.begin(), v2.end(), [](const Broj& a, const Broj& b) {
        return a.zbir < b.zbir;
    });
    
    p.duzina_niza_v2 = v2.size();  //broj razlicitih elemenata

    //PROMENA: sada pravimo mapu broj -> index
    vector<int> pozicija(p.duzina_niza_a + 1, -1);   // pozicija[b] = indeks u v2, ili -1 ako ga nema

    for(int i = 0; i < p.duzina_niza_v2; i++) {
        int b = v2[i].broj;   // ovo je konkretan broj (vrednost karte)
        pozicija[b] = i;      // b se nalazi na poziciji i u v2
    }

    //6) povezujemo svaki "Broj" u v2 pokazivacima prev i next
    v2[0].prev = -1;
    v2[0].next = 1;
    v2[p.duzina_niza_v2 - 1].next = -9;
    v2[p.duzina_niza_v2 - 1].prev = p.duzina_niza_v2 - 2;

    p.indeks_najmanjeg_broja = 0;
    p.indeks_najveceg_broja = p.duzina_niza_v2 - 1;

    //7)
    for(int i = 1; i <= p.duzina_niza_v2 - 2; i++) {
        v2[i].prev = i - 1;
        v2[i].next = i + 1;
    }

    for(int i = 0; i < Q; i++) {
        if(upiti[i].t == 1) {
            //8) Upit 1;
            p.broj_poteza = max(p.duzina_niza_v2 - p.duzina_niza_a + upiti[i].x, 0);
            cout << upit_1(v2, p) << '\n';
        }  
        else{
            //9) Upit 2:
            p.broj_koji_ubacujemo = upiti[i].y;
            p.broj_koji_izbacujemo = a[upiti[i].x-1];

            if(p.broj_koji_izbacujemo == p.broj_koji_ubacujemo) {
                continue;
            }
            
            p.indeks_broja_koji_izbacujemo = upiti[i].x-1;

            //promeni stari
            azuriraj_listu_izbacen_element(v2, pozicija, p);
            //azuriramo spil
            a[upiti[i].x - 1] = upiti[i].y;

            if(pozicija[upiti[i].y] == -1) {
                //dodaj novi
                azuriraj_listu_novi_dodati_element(v2, pozicija, p);
            }
            else{
                //promeni novi
                azuriraj_listu_dodat_element_koji_vec_postoji(v2, pozicija, p);
            }
        }
    }
    
    return 0;
}